DROP PROCEDURE [hips].[IhiUsageCount]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew Jacks
-- Create date:   31 July 2012
-- Description:   Returns the number of times an IHI has been used
--                by different patients.
--
-- This is used to implement HI CR 5839:
--     The software shall raise an exception alert whenever an IHI is assigned
--     to a patient record and the same IHI has already been assigned to one or
--     more other records of patients in the local system.
--
-- HIPS treats each hospital as a separate registration source, in which
-- case this stored procedure will only count duplicate IHI on a patient
-- master that has an MRN in the same hospital as an MRN of the patient
-- master whose IHI is being searched for.
-- 
-- Modified:
-- 27/05/2013 - Simon Biber - Add ability to filter by hospital.
-- 26/06/2013 - Simon Biber - Change the filter by hospital to a filter that counts
--                            those PMs which have MRNs from the same hospital as
--                            any MRN on the PM which is being searched.
-- =============================================
CREATE PROCEDURE [hips].[IhiUsageCount] 
(
	@PatientMasterId INT,
	@Ihi VARCHAR(50)
)
AS
BEGIN
	DECLARE @result INT
	SET @result = 0

	SELECT COUNT(DISTINCT pmi.PatientMasterId) AS IhiTimesUsed
	FROM  hips.PatientMasterIhi pmi
	INNER JOIN hips.HospitalPatient dupHP ON pmi.PatientMasterId=dupHP.PatientMasterId
	INNER JOIN hips.HospitalPatient thisHP ON dupHP.HospitalId = thisHP.HospitalId
	WHERE @Ihi = pmi.Ihi
	AND thisHP.PatientMasterId = @PatientMasterId
	AND dupHP.PatientMasterId <> @PatientMasterId -- Don't count the current PM
END
GO

